<?php
require 'composer/vendor/autoload.php'; // Include PhpSpreadsheet's autoload file

use PhpOffice\PhpSpreadsheet\IOFactory;

// Check if a file has been uploaded
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['excel_file'])) {
    try {
        // Check if the file was uploaded without any errors
        if ($_FILES['excel_file']['error'] == UPLOAD_ERR_OK) {
            // Get the uploaded file details
            $fileTmpPath = $_FILES['excel_file']['tmp_name'];
            $fileName = $_FILES['excel_file']['name'];
            $fileSize = $_FILES['excel_file']['size'];
            $fileType = $_FILES['excel_file']['type'];

            // Check for file type (allow only .xlsx and .xls files)
            $allowedExtensions = ['xlsx', 'xls'];
            $fileExtension = pathinfo($fileName, PATHINFO_EXTENSION);

            if (!in_array($fileExtension, $allowedExtensions)) {
                echo "Invalid file type. Please upload an Excel file.";
                exit;
            }

            // Load the uploaded Excel file using PhpSpreadsheet
            $spreadsheet = IOFactory::load($fileTmpPath);

            // Get the first sheet (you can change the index if you need a different sheet)
            $sheet = $spreadsheet->getSheet(0);  // Index 0 refers to the first sheet

            // Get all data in the sheet as an array
            $data = $sheet->toArray();
            
            if(!empty($data)){
                foreach($data as $pending_payment){
                    
                    $Reference = $pending_payment[0]; 
                    $Receipt_Number = $pending_payment[1]; 
                    $Payor = $pending_payment[2]; 
                    $Payment_Method = $pending_payment[3]; 
                    $Taken_By= $pending_payment[4];
                    $Operator = $pending_payment[5]; 
                    $Amount = $pending_payment[6]; 
                    $Create_Date = $pending_payment[7];
                    $Is_Burned = $pending_payment[8];
                    $Is_Void = $pending_payment[9];
                    
                
                    
                }
            }

            
        } else {
            echo 'Error uploading file: ' . $_FILES['excel_file']['error'];
        }
    } catch (Exception $e) {
        echo 'Error loading file: ', $e->getMessage();
    }
} else {
    // HTML form for file upload
    echo '
        <!DOCTYPE html>
        <html lang="en">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Upload Excel File</title>
        </head>
        <body>
            <h2>Upload Excel File</h2>
            <form action="" method="POST" enctype="multipart/form-data">
                <label for="excel_file">Choose Excel File:</label>
                <input type="file" name="excel_file" id="excel_file" accept=".xlsx, .xls" required>
                <button type="submit">Upload and Read</button>
            </form>
        </body>
        </html>';
}
?>
