<?php
include"admin/connection.php";

$hostname = 'localhost';
$username = 'govproprocessing_ncsw';
$password = 'govproprocessing_ncsw';
$database = 'govproprocessing_ncsw';

$backupDir = 'backup/';


if (!is_dir($backupDir)) {
    mkdir($backupDir, 0755, true);
}

// Create a backup of PHP files
$phpFilesBackup = $backupDir . 'php_files_' . date('Ymd_His') . '.zip';
$command = "zip -r $phpFilesBackup /path/to/your/php/files";
exec($command);

// Create a database backup
$mysqlDumpFile = $backupDir . 'database_backup_' . date('Ymd_His') . '.sql';
$command = "mysqldump -h$hostname -u$username -p$password $database > $mysqlDumpFile";
exec($command);

// Define the retention period (7 days)
$retentionPeriod = 7 * 24 * 60 * 60; // 7 days in seconds

// Get the current time
$currentTime = time();

// Iterate through the backup directory and delete old files
foreach (new DirectoryIterator($backupDir) as $fileInfo) {
    if ($fileInfo->isDot()) {
        continue;
    }
    if ($fileInfo->isFile()) {
        $filePath = $fileInfo->getRealPath();
        $fileModificationTime = $fileInfo->getMTime();

        // Check if the file is older than the retention period
        if ($currentTime - $fileModificationTime > $retentionPeriod) {
            unlink($filePath); // Delete the file
        }
    }
}

echo 'Backup completed successfully.';

?>