<?php
ob_start();
include('../cashier/connection.php');
require('fpdf186/fpdf.php');

if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Transaction ID is missing.");
}

$id = mysqli_real_escape_string($conn, $_GET['id']);

// JOIN transactions with customers using user_id
$sql = "SELECT t.*, c.name AS customer_name
        FROM transcations t
        LEFT JOIN customers c ON t.user_id = c.id
        WHERE t.transaction_id = '$id'
        LIMIT 1";

$result = mysqli_query($conn, $sql);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Transaction not found for ID: $id");
}

$row = mysqli_fetch_assoc($result);

$txn_id = $row['transaction_id']; 
$name = $row['customer_name'] ?? 'Customer';
$account = $row['card'] ?? '';
$payment = floatval($row['amount'] ?? 0);
$fee = floatval($row['fee_amount'] ?? 0);
$total = $payment + $fee;
$date = date('Y-m-d h:i A', strtotime($row['date_time']));

$account_clean = preg_replace('/[^0-9]/', '', $account);
$masked_account = str_repeat('*', strlen($account_clean) - 2) . substr($account_clean, -2);

// PDF Creation
$pdf = new FPDF();
$pdf->AddPage();

if (file_exists('logo.png')) {
    $pdf->Image('logo.png', 10, 6, 40);
}

$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'North Central Solid Waste Authority', 0, 1, 'C');

$pdf->SetFont('Arial', 'B', 16);
$pdf->Cell(0, 10, 'Payment Receipt', 0, 1, 'C');

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 5, "Date: $date", 0, 1, 'C');
$pdf->Ln(20);

$pdf->SetFont('Arial', 'B', 12);
$pdf->SetFillColor(220, 220, 220);
$pdf->Cell(190, 10, 'Details', 1, 1, 'C', true);

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(60, 10, 'Customer Name:', 1);
$pdf->Cell(130, 10, $name, 1, 1);

$pdf->Cell(60, 10, 'Account/Card:', 1);
$pdf->Cell(130, 10, $masked_account, 1, 1);

$pdf->Cell(60, 10, 'Transaction ID:', 1);
$pdf->Cell(130, 10, $txn_id, 1, 1);

$pdf->Cell(60, 10, 'Payment Amount:', 1);
$pdf->Cell(130, 10, '$' . number_format($payment, 2), 1, 1);

$pdf->Cell(60, 10, 'Convenience Fee:', 1);
$pdf->Cell(130, 10, '$' . number_format($fee, 2), 1, 1);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(60, 10, 'Total Payment:', 1);
$pdf->Cell(130, 10, '$' . number_format($total, 2), 1, 1);

$pdf->Ln(15);
$pdf->SetFont('Arial', 'I', 10);
$pdf->Cell(0, 10, 'Thank you! This is a system-generated receipt.', 0, 1, 'C');

$pdf->Output('I', 'receipt_' . $txn_id . '.pdf');
exit;
ob_end_flush();
