<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Hardcoded test credentials
    $postData = [
        "CUST_NBR"     => "9001",
        "MERCH_NBR"    => "900300",
        "DBA_NBR"      => "2",
        "TERMINAL_NBR" => "68",
        "TRAN_TYPE"    => "CCE1",
        "BATCH_ID"     => "20240614",
        "TRAN_NBR"     => "5",
        "CARD_ENT_METH"=> "E",
    ];


    if (!empty($_POST["AUTH_AMOUNT"])) {
        $amount = number_format((float)$_POST["AUTH_AMOUNT"], 2, '.', '');
        $postData["AMOUNT"] = $amount;
    }
    
    // User input
    foreach (["ACCOUNT_NBR","EXP_DATE","CVV2","FIRST_NAME","LAST_NAME","ADDRESS","CITY","STATE","ZIP_CODE"] as $field) {
        if (!empty($_POST[$field])) {
            $postData[$field] = $_POST[$field];
        }
    }

    // Call API
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://secure.epxuap.com/',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => http_build_query($postData),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);
    $error = curl_error($curl);
    curl_close($curl);

    if ($error) {
        $alert = ["type" => "danger", "msg" => "cURL Error: " . $error];
    } elseif (!empty($response)) {
        // Parse XML
        $xml = simplexml_load_string($response);
        $fields = [];
        if ($xml && isset($xml->FIELDS->FIELD)) {
            foreach ($xml->FIELDS->FIELD as $field) {
                $key = (string)$field['KEY'];
                $value = (string)$field;
                $fields[$key] = $value;
            }
        }

        if (!empty($fields["AUTH_RESP"]) && $fields["AUTH_RESP"] === "00") {
            $alert = ["type" => "success", "msg" => "Payment successful! Auth Code: ".$fields["AUTH_CODE"]];
        } else {
            $reason = $fields["AUTH_RESP_TEXT"] ?? "Unknown error";
            $alert = ["type" => "danger", "msg" => "Payment failed: $reason"];
        }
    } else {
        $alert = ["type" => "danger", "msg" => "No response from payment gateway."];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>EPX Card Payment</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-4">
  <div class="card shadow p-4" style="width:40%; margin:auto;">
    <h4 class="mb-3">One-time EPX Card Payment</h4>
    <form method="POST">
    <div class="row g-3">
        <div class="col-md-12">
          <label class="form-label">Amount</label>
          <input type="text" name="AUTH_AMOUNT" class="form-control" placeholder="e.g. 12.00" required>
        </div>
        <div class="col-md-12">
          <label class="form-label">Card Number</label>
          <input type="text" name="ACCOUNT_NBR" class="form-control" placeholder="e.g. 4111111111111111" required>
        </div>
        <div class="col-md-12">
          <label class="form-label">Expiry (YYMM)</label>
          <input type="text" name="EXP_DATE" class="form-control" placeholder="e.g. 123" required>
        </div>
        <div class="col-md-12">
          <label class="form-label">CVV</label>
          <input type="text" name="CVV2" class="form-control" placeholder="e.g. 123" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">First Name</label>
          <input type="text" name="FIRST_NAME" class="form-control" placeholder="test" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Last Name</label>
          <input type="text" name="LAST_NAME" class="form-control" placeholder="test" required>
        </div>
        <div class="col-md-12">
          <label class="form-label">Address</label>
          <input type="text" name="ADDRESS" class="form-control" placeholder="e.g. 123 Main Street" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">City</label>
          <input type="text" name="CITY" class="form-control" placeholder="e.g. Lubbock" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">State</label>
          <input type="text" name="STATE" class="form-control" placeholder="e.g. TX" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">ZIP</label>
          <input type="text" name="ZIP_CODE" class="form-control" placeholder="12345" required>
        </div>
      </div>
      <button type="submit" class="btn btn-primary mt-3">Submit Payment</button>
    </form>

    <?php if (!empty($alert)): ?>
      <div class="alert alert-<?= $alert['type'] ?> mt-4">
        <?= htmlspecialchars($alert['msg']) ?>
      </div>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
