<?php 
include "header.php";
include "mandrill_email_function.php";  
date_default_timezone_set('America/Denver');


$selected_accounts = $_POST['multiple_accounts'] ?? [];
$child_amounts     = $_POST['child_payment_amount'] ?? [];
$accounts_with_payments = [];

if (!empty($selected_accounts)) {
    $id_list = implode(",", array_map('intval', $selected_accounts));
    $query = "
        SELECT 
            customer_accounts.id AS account_id,
            customer_accounts.account_number,
            customers.id AS customer_id,
            customers.name,
            customers.email,
            customers.address
        FROM customer_accounts
        LEFT JOIN customers ON customers.id = customer_accounts.customer_id
        WHERE customer_accounts.customer_id IN ($id_list)
    ";

    $result = mysqli_query($conn, $query);

    while ($row = mysqli_fetch_assoc($result)) {
        $payment_amount = isset($child_amounts[$row['account_id']]) ? floatval($child_amounts[$row['account_id']]) : 0;
        $accounts_with_payments[] = [
            'account_id' => $row['account_id'],
            'customer_id' => $row['customer_id'],
            'payment_amount' => $payment_amount,
            'account_number' => $row['account_number'],
        ];
    }
}

$first_customer_id = $accounts_with_payments[0]['customer_id'] ?? null;
print_r($first_customer_id);
// die();

// if (!empty($selected_accounts)) {
//     $id_list = implode(",", array_map('intval', $selected_accounts));

//     $query = "
//         SELECT 
//             customer_accounts.id AS account_id,
//             customer_accounts.account_number,
//             customers.id AS customer_id,
//             customers.name,
//             customers.email,
//             customers.address
//         FROM customer_accounts
//         LEFT JOIN customers ON customers.id = customer_accounts.customer_id
//         WHERE customer_accounts.customer_id IN ($id_list)
//     ";
    
//     $result = mysqli_query($conn, $query);

//     while ($row = mysqli_fetch_assoc($result)) {
//         $account_id = $row['account_id'];
//         $payment_amount = isset($child_amounts[$account_id]) ? floatval($child_amounts[$account_id]) : 0;

//         echo "<div style='margin-bottom:10px;'>
//             <strong>Customer:</strong> {$row['name']}<br>
//             <strong>Account #:</strong> {$row['account_number']}<br>
//             <strong>Amount:</strong> $" . number_format($payment_amount, 2) . "
//         </div>";
//     }
// }


// Get NMI settings
$sql_nmi_api_settings = "SELECT * FROM nmi_api_settings ORDER BY id DESC LIMIT 1";
$result_nmi_api_settings = mysqli_query($conn, $sql_nmi_api_settings);
$row_nmi_api_settings = mysqli_fetch_assoc($result_nmi_api_settings);
$name =  $row_nmi_api_settings['name'];
$url_db =  $row_nmi_api_settings['url'];
$api_key =  $row_nmi_api_settings['api_key'];

// Pull values from POST
$child_payment_amounts = $_POST['child_payment_amount'] ?? [];
$only_fee_amount = str_replace(",", "", $_POST['only_fee_amount'] ?? 0);
$inperson_online_check = $_POST['inperson_online_check'];
$user_id = $_POST['user_id'];
$customer_name = $_POST['firstname'];
$customer_email = $_POST['email'];

$card_number = $_POST['card_number'];
$expiry = $_POST['expiry'];
$card_cvv = $_POST['card_cvv'];
$card_name = $_POST['card_name'];
$name_parts = explode(' ', trim($card_name));
$firstname = $name_parts[0];
$lastname = isset($name_parts[1]) ? $name_parts[1] : '';

$multiple_accounts = $_POST['multiple_accounts'] ?? [];

// --- 1. Calculate total amount for single NMI transaction ---
$total_amount_api = 0;
foreach ($accounts_with_payments as $account) {
    $payment_amount = $account['payment_amount'];
    $fee_amount = ($account['customer_id'] == $first_customer_id) ? floatval($only_fee_amount) : 0;
    $total_amount_api += $payment_amount + $fee_amount;
    $total_amount_api = number_format($total_amount_api, 2, '.', '');

}

// --- 2. Single NMI transaction ---
$url = "https://$url_db/api/transact.php";

echo "<pre>Total amount sent to NMI: $total_amount_api</pre>";

$post_fields = [
    "security_key" => "$api_key",
    'type' => 'sale',
    'amount' => "$total_amount_api",
    'ccnumber' => "$card_number",
    'ccexp' => "$expiry",
    'cvv' => "$card_cvv",
    'orderid' => 'ORD-' . time() . rand(1000, 9999),
    'firstname' => $firstname,
    'lastname' => $lastname,
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);

// echo "<pre>Raw NMI response:\n";
// print_r($response);
// echo "</pre>";
curl_close($ch);

parse_str($response, $response_array);
$transaction_id = $response_array['transactionid'] ?? '';
$response_text = $response_array['responsetext'] ?? 'Declined';
// echo "<pre>Parsed response array:\n";
// print_r($response_array);
// echo "</pre>";

$curl = curl_init();
curl_setopt_array($curl, [
  CURLOPT_URL => "https://secure.nmi.com/api/query.php",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST => true,
  CURLOPT_POSTFIELDS => "transaction_id=$transaction_id&security_key=$api_key",
  CURLOPT_HTTPHEADER => [
    "accept: application/xml",
    "content-type: application/x-www-form-urlencoded"
  ],
]);
$response_query = curl_exec($curl);
curl_close($curl);

$Card = "";
if ($response_query) {
    $xml = simplexml_load_string($response_query);
    foreach ($xml->transaction as $transaction) {
        $cc_type = (string)$transaction->cc_type;
        $cc_bin = (string)$transaction->cc_bin;
        $Card = $cc_type . " (" . $cc_bin . "****)";
        $response_text = (string)$transaction->action->response_text;
    }
}



foreach ($accounts_with_payments as $account) {
    $account_id = $account['account_id'];
    $customer_id = $account['customer_id'];
    $account_payment_amount = $account['payment_amount'];

    if ($account_payment_amount <= 0) {
        continue;  
    }

    // Fee only for parent user
    $fee_amount = ($customer_id == $first_customer_id) ? floatval($only_fee_amount) : 0;

    $total_amount_account = $account_payment_amount + $fee_amount;

    $user_account = $account['account_number'] ?? '';

    $amount_without_fee_formatted = number_format($account_payment_amount, 2, '.', '');
    $fee_amount_formatted = number_format($fee_amount, 2, '.', '');
    $amount_to_store_formatted = number_format($total_amount_account, 2, '.', '');
    $Date = date('Y-m-d');
    $time = date('H:i:s');

    $sql_transcations = "INSERT INTO `transcations`(
        `date_time`,
        `amount_without_fee`,
        `fee_amount`,
        `transaction_id`,
        `status`,
        `amount`,
        `card`,
        `date`,
        `time`,
        `user_id`,
        `user_type`,
        `inperson_online_check`
    ) VALUES (
        '$Date $time',
        '$amount_without_fee_formatted',
        '$fee_amount_formatted',
        '$transaction_id',
        '$response_text',
        '$amount_to_store_formatted',
        '$Card',
        '$Date',
        '$time',
        '$customer_id',
        'customer',
        '$inperson_online_check'
    )";
    $result_transcations = mysqli_query($conn, $sql_transcations);
    
    $last_inserted_transcation_db_id = mysqli_insert_id($conn);

    // Send confirmation email per account if needed
    $email_body = "Your payment of $" . number_format($total_amount_account, 2) . ".<br>
                   Transaction ID: $transaction_id.<br>
                   Status: <strong>$response_text</strong>";
    $email_subject = "Payment Details";
    sendMandrillEmail($customer_email, $email_body, $email_subject, $customer_name);

   

    
?>

<!-- Print receipt -->
<style>
@media print {
  body { margin:0; padding:0; font-size:12pt; }
  .no-print { display:none; }
  html, body { height:100%; width:100%; overflow:hidden; }
  .print-container { page-break-inside:avoid; page-break-after:avoid; page-break-before:avoid; }
}
</style>

<div class="container print-container" style="margin-top: 5rem !important;">
  <div class="row">
    <div class="col-lg-12">
      <div class="card">
         <div class="card-header pb-0">
          <?php if($response_text=='SUCCESS' || $response_text=='Approved'){ ?>
            <div class="card-title mb-0">Thank You, for your payment!! </div>
          <?php } else { ?>
            <div class="card-title mb-0">PAYMENT FAILED, PLEASE TRY AGAIN
             <br><?php echo $response_text;?>
            </div>
          <?php } ?>
         </div>
         <?php if($result_transcations){ ?>
         <div class="card-body">
            <div class="table-responsive">
               <table class="table table-bordered">
                  <tbody>
                     <tr>
                        <td>Account # </td>
                        <td class="text-end"><?php echo $user_account;?></td>
                     </tr>
                     <tr>
                        <td>Payment Subtotal</td>
                        <td class="text-end">$<?php echo number_format($total_amount_account,2);?></td>
                     </tr>
                     <tr>
                        <td><span>Totals</span></td>
                        <td class="text-end text-muted"><span>$<?php echo number_format($total_amount_account,2);?></span></td>
                     </tr>
                     <tr>
                        <td><span>Payment Total</span></td>
                        <td><h2 class="price text-end mb-0">$<?php echo number_format($total_amount_account,2);?></h2></td>
                     </tr>
                  </tbody>
               </table>
            </div>
            <a href="download_invoice.php?id=<?php echo $last_inserted_transcation_db_id; ?>&transcation_id=<?php echo $transaction_id; ?>" target="_blank" class="btn btn-primary buttons-excel buttons-html5">Print</a>
            <iframe id="invoiceFrame"
                    src="download_invoice.php?id=<?php echo $last_inserted_transcation_db_id; ?>&transcation_id=<?php echo $transaction_id; ?>"
                    style="display:none;"
                    onload="document.getElementById('invoiceFrame').contentWindow.print();">
            </iframe>
         </div>
         <?php } ?>
      </div>
    </div>
  </div>
</div>

<?php }  ?>
<?php include "footer.php"; ?>
