<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this Account?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['account_id'])) {
    $customer_id = (int) $_GET['account_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `customer_accounts` SET `is_active`='0' WHERE `id`='$customer_id'";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> Customer deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the customer.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_pending_payments.php?account_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

// ✅ ADDED: Search input handling
$search = "";
$where = "customer_accounts.is_active = 1 AND customer_accounts.customer_id = '$login_user_id' AND customer_accounts.balance > 0";

if (isset($_GET['search']) && !empty(trim($_GET['search']))) {
    $search = mysqli_real_escape_string($conn, trim($_GET['search']));
    $where .= " AND (
        customers.name LIKE '%$search%' OR 
        customer_accounts.account_number LIKE '%$search%' OR 
        customer_accounts.balance LIKE '%$search%' OR 
        customer_accounts.last_update LIKE '%$search%'
    )";
}

// Pagination setup
$customers_per_page = 100;
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

// Fetch paginated customer accounts with search
$query_customers = "SELECT customer_accounts.*, customers.name, customers.email as customer_email 
                    FROM customer_accounts 
                    LEFT JOIN customers ON customers.id = customer_accounts.customer_id 
                    WHERE $where
                    ORDER BY customers.name ASC 
                    LIMIT $offset, $customers_per_page";
$result_customers = mysqli_query($conn, $query_customers);

// Get total count for pagination (with search)
$total_count_query = "SELECT COUNT(*) as total 
                      FROM customer_accounts 
                      LEFT JOIN customers ON customers.id = customer_accounts.customer_id 
                      WHERE $where";
$total_count_result = mysqli_query($conn, $total_count_query);
$total_count_row = mysqli_fetch_assoc($total_count_result);
$total_records = $total_count_row['total'];
$total_pages = ceil($total_records / $customers_per_page);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="card-title">Manage Pending Payments</h3>
                    </div>
                    <div class="col-md-4">
                        <form method="GET" class="mb-3">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="Search by name, account number, balance, etc." value="<?php echo htmlspecialchars($search); ?>">
                        <button type="submit" class="btn btn-primary">Search</button>
                    </div>
                    </form>

                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>

                
                <div class="table-responsive">
                    <table id="file-datatable" class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Account Number</th>
                                <th>Balance</th>
                                <th>Last Update</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_array($result_customers)) {
                                $last_update = $row['last_update'];
                                // Check if the $last_update is not empty or invalid
                                    if (!empty($last_update) && strtotime($last_update) !== false) {
                                        // Convert the string to a timestamp
                                        $timestamp = strtotime($last_update);
                                        
                                        // Format both date and time in US format (mm/dd/yyyy hh:mm:ss AM/PM)
                                        $formatted_last_update = date('m/d/Y h:i:s A', $timestamp);
                                    } else {
                                        // Handle the case where the date is empty or invalid
                                        $formatted_last_update = '';
                                    }
                            ?>
                                <tr>
                                    <td><?php echo $counter++; ?></td>
                                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['account_number']); ?></td>
                                    <td>$<?php echo number_format( htmlspecialchars($row['balance']),2); ?></td>
                                    <td><?php echo $formatted_last_update; ?></td>
                                    <td>
                                        <a href="pay_now.php" target="_blank" class="btn btn-primary-light rounded-pill btn-wave waves-effect waves-light">Pay</a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="mt-3">
                        <ul class="pagination">
                            <?php
                            $query_params = $_GET;
                            unset($query_params['page']); // Avoid duplicate page params

                            if ($current_page > 1) {
                                $query_params['page'] = $current_page - 1;
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?' . http_build_query($query_params) . '">Previous</a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $query_params['page'] = $i;
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?' . http_build_query($query_params) . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                $query_params['page'] = $current_page + 1;
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?' . http_build_query($query_params) . '">Next</a></li>';
                            }
                            ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

