<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this Account?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['account_id'])) {
    $customer_id = (int) $_GET['account_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `customer_accounts` SET `is_active`='0' WHERE `id`='$customer_id'";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> Customer deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the customer.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_accounts.php?account_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

$customers_per_page = 25;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

// First query
$query_customers = "
SELECT customers.*, customer_accounts.account_number 
FROM customers 
LEFT JOIN customer_accounts 
    ON customer_accounts.customer_id = customers.id 
WHERE customers.parent = '$login_user_id' OR customers.id = '$login_user_id' 
ORDER BY customers.id DESC";

$result_customers = mysqli_query($conn, $query_customers);

// Track duplicates
$seen_ids = [];
$customers = [];

// Fetch unique customers from first query
while ($row = mysqli_fetch_assoc($result_customers)) {
    if (!in_array($row['id'], $seen_ids)) {
        $seen_ids[] = $row['id'];
        $customers[] = $row;
    }
}

// Prepare for second query (child of first parent found)
$parent_id = -1;
foreach ($customers as $c) {
    if ((int)$c['parent'] > 0) {
        $parent_id = (int)$c['parent'];
        break;
    }
}

// Second query if valid parent ID found
if ($parent_id > 0) {
    $query_customers_2 = "
    SELECT customers.*, customer_accounts.account_number 
    FROM customers 
    LEFT JOIN customer_accounts 
        ON customer_accounts.customer_id = customers.id 
    WHERE customers.parent = '$parent_id' OR customers.id = '$parent_id' 
    ORDER BY customers.id ASC";

    $result_customers_2 = mysqli_query($conn, $query_customers_2);

    while ($row = mysqli_fetch_assoc($result_customers_2)) {
        if (!in_array($row['id'], $seen_ids)) {
            $seen_ids[] = $row['id'];
            $customers[] = $row;
        }
    }
}
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="card-title">Manage Accounts</h3>
                    </div>
                    <div class="col-md-4">
                        <a class="btn btn-outline-primary float-end" href="add_account_test.php" title="Add New Account">Add New Account</a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Account Number</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = 1;
                            foreach ($customers as $row) {
                            ?>
                                <tr>
                                    <td><?php echo $counter++; ?></td>
                                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['account_number']); ?></td>
                                    <td>
                                        <form action="../customer/login.php" method="POST" target="_blank">
                                            <input type="text" value="<?php echo htmlspecialchars($row['id']); ?>" name="auto_login_user" style="display:none">
                                            <input type="submit" href="" target="_blank" class="btn btn-primary-light rounded-pill btn-wave waves-effect waves-light" value="Access Account">
                                        </form>
                                    </td>
                                </tr>
                            <?php } ?>
                            
                            
                            
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers">
                            <ul class="pagination">
                                <?php
                                $total_records = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `customer_accounts` where is_active =1 AND customer_id='$login_user_id'"));
                                $total_pages = ceil($total_records / $customers_per_page);

                                for ($i = 1; $i <= $total_pages; $i++) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . '" class="page-link">' . $i . '</a></li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
