<?php include 'header.php'; ?> 
<style>
  .hero-image {
    border-radius:10px;
    background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)),
      url("https://northcentralsolidwasteauthoritynm.municipalonlinepayments.com/northcentralsolidwasteauthoritynm/images/Banner?t=637092564386716539");
    height: 57vh;
    /* CHANGED */
    background-position: center;
    background-repeat: no-repeat;
    background-size: cover;
    position: relative;
  }

  .hero-text {
    text-align: center;
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    color: white;
  }

  .card-container {
    display: flex;
    justify-content: space-around;
    margin: 20px 0;
  }

  .card1 {
    color: #364c62;
    background: white;
    border: 1px solid #ddd;
    border-radius: 10px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    text-align: center;
    width: 30%;
  }

  .info-container {
    display: flex;
    justify-content: space-around;
    margin: 20px 0;
  }
  
  .customer-name-class {
    font-size: 36px;  
    margin-top: 10px; 
  }
  
  .customer-address-class {
    font-size: 18px;  
  }
  
  .customer-balance-class {
    font-size: 30px;  
  }
  
  @media (max-width: 767px) {
        .card1 {
            width: 100%;
        }
        .forge-typography--subheading4 {
            display: none;
        }
      .customer-name-class {
        font-size: 18px;  
      }
      
      .customer-address-class {
        font-size: 9px;  
      }
      
      .customer-balance-class {
        font-size: 15px;  
      }
    }
    
    .modal-backdrop.show {
    background-color: #00000063 !important;
    }
.modal-backdrop {
    background-color: transparent !important; /* no black */
    transition: none !important; /* remove fade transition */
}
.modal-content {
    height:300px !important;
}
.modal-dialog.modal-xl{
    margin-top:8rem !important;
}
</style>
<?php
$invalid_accounts = [];
$seen_ids = [];
$all_customers = [];

$query = "
    SELECT customers.id, customers.name, customer_accounts.id AS acc_id, customer_accounts.account_number
    FROM customers
    LEFT JOIN customer_accounts ON customer_accounts.customer_id = customers.id
    WHERE customers.id = '$login_user_id' OR customers.parent = '$login_user_id'
";
$result = mysqli_query($conn, $query);
while($row = mysqli_fetch_assoc($result)){
    if(!in_array($row['id'], $seen_ids)){
        $seen_ids[] = $row['id'];
        $all_customers[] = $row;
    }
}

foreach($all_customers as $c){
    $parent_id = $c['id'];
    $res = mysqli_query($conn, "
        SELECT customers.id, customers.name, customer_accounts.id AS acc_id, customer_accounts.account_number
        FROM customers
        LEFT JOIN customer_accounts ON customer_accounts.customer_id = customers.id
        WHERE customers.parent = '$parent_id'
    ");
    while($r = mysqli_fetch_assoc($res)){
        if(!in_array($r['id'], $seen_ids)){
            $seen_ids[] = $r['id'];
            $all_customers[] = $r;
        }
    }
}

foreach($all_customers as $c){
    if(!empty($c['account_number']) && !preg_match('/^\d{2}-\d{7}-\d{2}$/', trim($c['account_number']))){
        $invalid_accounts[] = [
            'id' => $c['acc_id'],
            'account_number' => $c['account_number'],
            'customer_name' => $c['name']
        ];
    }
}

$alert = '';
if(count($invalid_accounts) > 0){
    $alert = '<div class="alert alert-danger alert-dismissible fade show" role="alert">
               Your Account Number format is incorrect, Please update.
               &nbsp;  &nbsp;
               <a href="javascript:void(0);" 
                  class="btn btn-sm btn-primary" 
                  style="font-size:14px;"
                  data-bs-toggle="modal" 
                  data-bs-target="#manageAccountsModal">
                  Update Account Number
               </a>
              </div>';
}
?>

<div class="hero-image">
    <?php echo $alert; ?>
  <div class="hero-text">
    <div class="header-content--text">
      <div class="forge-typography--subheading4" style="font-size:18px;">Welcome Back!</div>
      <div class="forge-typography--subheading7 header-text-margin header-text-width customer-name-class"><?php echo $customer_name; ?></div>
      <div class="forge-typography--subheading7 header-text-margin header-text-width customer-address-class"><i><?php echo $customer_address; ?></i><br></div>
      <div class="forge-typography--body2 header-text-margin customer-balance-class"> Your current balance is $<span style="font-weight: 700;"><?php echo number_format($my_last_pending_payments,2); ?> </span>
      </div>
    </div>
    <button class="btn btn-primary px-5 d-none">Pay Now</button>
    
    <div class="card-container">
    
      <div class="card1 ">
        <a href="pay_now.php">
        <p><img src="assets/img/billpay.png" style="max-width: 55%;" ></p>
        <div>Pay Bill</div>
        </a>
      </div>
    

      <div class="card1  ">
          <a href="manage_auto_payments.php">
        <p><img src="assets/img/optin.png" style="max-width: 55%;"></p>
        <div>Enroll in Auto Pay</div>
        </a>
      </div>
    </div>
  </div>
</div>
<br>
<br>

<!-- Manage Accounts Modal -->
<div class="modal fade" id="manageAccountsModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Plese update accounts to proceed!</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">X</button>
      </div>
      <div class="modal-body p-0">
        <?php if(count($invalid_accounts) == 0): ?>
            <div class="alert alert-success">No invalid accounts!</div>
        <?php else: ?>
            <table class="table table-bordered mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Customer Name</th>
                        <th>Account Number (11-1234567-89)</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($invalid_accounts as $index => $acc): ?>
                    <tr>
                        <td><?php echo $index+1; ?></td>
                        <td><?php echo $acc['customer_name'] ?></td>
                        <td>
                            <input type="text" class="form-control account-input" data-id="<?php echo $acc['id']; ?>" value="<?php echo htmlspecialchars($acc['account_number']); ?>" maxlength="13">
                        </td>
                        <td>
                            <button class="btn btn-primary btn-update" data-id="<?php echo $acc['id']; ?>">Update</button>
                            <span class="update-status" id="status-<?php echo $acc['id']; ?>"></span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
const patternInputs = document.querySelectorAll('.account-input');
patternInputs.forEach(function(input){
    input.addEventListener('input', function(){
        let val = this.value.replace(/\D/g,'');
        if(val.length > 2 && val.length <= 9){
            val = val.slice(0,2) + '-' + val.slice(2);
        } else if(val.length > 9){
            val = val.slice(0,2) + '-' + val.slice(2,9) + '-' + val.slice(9,11);
        }
        this.value = val;
    });
});

$('.btn-update').on('click', function(){
    let id = $(this).data('id');
    let account_number = $('input[data-id="'+id+'"]').val();
    let statusEl = $('#status-'+id);
    statusEl.text('');
    
    $.post('update_account_ajax.php', {id: id, account_number: account_number}, function(data){
        if(data.success){
            statusEl.html('<span class="text-success">Updated!</span>');
            
            // Remove the row after short delay
            setTimeout(function(){
                $('button[data-id="'+id+'"]').closest('tr').fadeOut(function(){
                    $(this).remove();
                    
                    // If no more rows left, close modal + refresh page
                    if($('#manageAccountsModal tbody tr').length === 0){
                        var myModalEl = document.getElementById('manageAccountsModal');
                        var modal = bootstrap.Modal.getInstance(myModalEl);
                        modal.hide();
                        location.reload();
                    }
                });
            }, 500);
            
        } else {
            statusEl.html('<span class="text-danger">'+data.message+'</span>');
        }
    }, 'json');
});

</script>


<script>
<?php if (isset($_GET['show_invalid']) && $_GET['show_invalid'] == 1 && count($invalid_accounts) > 0): ?>
  $(document).ready(function(){
      var modal = new bootstrap.Modal(document.getElementById('manageAccountsModal'));
      modal.show();
  });
<?php endif; ?>
</script>

<?php 
include "footer_above_section.php";
include 'footer.php'; 
?>



