<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this user?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['users_id'])) {
    $users_id = (int) $_GET['users_id']; // Cast to integer for safety

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        // Perform the deletion
        $delete_query = "DELETE FROM `admin_users` WHERE id = $users_id";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> You have successfully deleted the user.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger mg-b-0" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Oh snap!</strong> Failed to delete the user. Please try again.
                    </div>';
        }
    } else {
        // Show confirmation prompt
        echo '<script>if(confirmDelete()) { window.location.href = "manage_users.php?users_id=' . $users_id . '&confirm=yes"; }</script>';
    }
}

$users_per_page = 25;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $users_per_page;

// Corrected JOIN with pagination
$query_users = "SELECT user.*, user_type.type as type_user 
                FROM `admin_users` AS user 
                LEFT JOIN user_type ON user_type.id = user.user_type 
                ORDER BY user.id DESC 
                LIMIT $users_per_page OFFSET $offset";

$result_users = mysqli_query($conn, $query_users);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="card-title">Manage Users</h3>
                    </div>
                    <div class="col-md-4">
                        <a class="btn btn-outline-primary ms-auto float-end" href="add_user.php" data-bs-placement="top" data-bs-toggle="tooltip" title="Add New User">Add New User</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table id="file-datatable" class="border-top-0 table table-bordered text-nowrap key-buttons border-bottom dataTable no-footer">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>User Name</th>
                                <th>Email</th>
                                <th>User Type</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row_users = mysqli_fetch_array($result_users)) {
                            ?>
                                <tr>
                                    <td><?php echo $counter; ?></td>
                                    <td><?php echo htmlspecialchars($row_users['user_name']); ?></td>
                                    <td><?php echo htmlspecialchars($row_users['user_email']); ?></td>
                                    <td><?php echo htmlspecialchars($row_users['type_user']); ?></td>
                                    <td>
                                        <a href="update_user.php?users_id=<?php echo $row_users['id']; ?>"><i class="si si-note" title="Update User"></i></a>
                                        <a href="manage_users.php?users_id=<?php echo $row_users['id']; ?>"><i class="si si-close" title="Delete User"></i></a>
                                    </td>
                                </tr>
                            <?php 
                                $counter++;
                            } 
                            ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers">
                            <ul class="pagination">
                                <?php
                                $total_records = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `admin_users`"));
                                $total_pages = ceil($total_records / $users_per_page);

                                for ($i = 1; $i <= $total_pages; $i++) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . '" class="page-link">' . $i . '</a></li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
