<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this customer?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['customer_id'])) {
    $customer_id = (int) $_GET['customer_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "DELETE FROM `customers` WHERE id = $customer_id";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> Customer deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the customer.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_customer.php?customer_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

$customers_per_page = 25;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

$query_customers = "SELECT * FROM `customers` ORDER BY id DESC LIMIT $customers_per_page OFFSET $offset";
$result_customers = mysqli_query($conn, $query_customers);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="card-title">Manage Customers</h3>
                    </div>
                    <div class="col-md-4">
                        <a class="btn btn-outline-primary float-end" href="add_customer.php" title="Add New Customer">Add New Customer</a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Card Number</th>
                                <th>Address</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_array($result_customers)) {
                            ?>
                                <tr>
                                    <td><?php echo $counter++; ?></td>
                                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['email']); ?></td>
                                    <td><?php echo htmlspecialchars($row['phone']); ?></td>
                                    <td><?php echo htmlspecialchars($row['card_number']); ?></td>
                                    <td><?php echo htmlspecialchars($row['address']); ?></td>
                                    <td><?php echo htmlspecialchars($row['created_at']); ?></td>
                                    <td>
                                        <a href="update_customer.php?customer_id=<?php echo $row['id']; ?>"><i class="si si-note" title="Update Customer"></i></a>
                                        <a href="manage_customer.php?customer_id=<?php echo $row['id']; ?>"><i class="si si-close" title="Delete Customer"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers">
                            <ul class="pagination">
                                <?php
                                $total_records = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `customers`"));
                                $total_pages = ceil($total_records / $customers_per_page);

                                for ($i = 1; $i <= $total_pages; $i++) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . '" class="page-link">' . $i . '</a></li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
