<?php 
include "header.php"; 

$transcations_per_page = 500; 
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $transcations_per_page;

if (isset($_GET['filter_date'])) {
    $raw_filter_date = $_GET['filter_date'];

    if ($raw_filter_date === 'all') {
        $filter_date = ''; // display helper
        $filter_sql = '';  // no filter
    } elseif ($raw_filter_date === 'today') {
        $filter_date = date('Y-m-d');
        $filter_sql = " AND `date` = '$filter_date'";
    } else {
        $filter_date = mysqli_real_escape_string($conn, $raw_filter_date);
        $filter_sql = " AND `date` = '$filter_date'";
    }
} else {
    // Default to today if not set
    $filter_date = date('Y-m-d');
    $filter_sql = " AND `date` = '$filter_date'";
}


$filter_sql = '';

if (!empty($filter_date)) {
    $filter_sql = " AND `date` = '$filter_date'";
}

$search_transaction = isset($_GET['search_transaction']) ? trim(mysqli_real_escape_string($conn, $_GET['search_transaction'])) : '';

if (!empty($search_transaction)) {
    $filter_sql .= " AND transaction_id LIKE '%$search_transaction%'";
}


$date_query = "SELECT DISTINCT `date` FROM `transcations` WHERE `user_id` = '$login_user_id' ORDER BY `date` DESC";
$date_result = mysqli_query($conn, $date_query);
$available_dates = [];

while ($row = mysqli_fetch_assoc($date_result)) {
    $available_dates[] = $row['date'];
}





// Count total records
$count_query = "SELECT COUNT(*) AS total FROM `transcations` WHERE `user_id`='$login_user_id' $filter_sql";
$total_records_result = mysqli_query($conn, $count_query);
$total_records_row = mysqli_fetch_assoc($total_records_result);
$total_records = $total_records_row['total'];
$total_pages = ceil($total_records / $transcations_per_page);

// Fetch paginated transactions
 $sql_transcations = "SELECT * FROM `transcations` 
                    WHERE `user_id`='$login_user_id' $filter_sql AND `status` != 'Error'
                    ORDER BY `id` DESC 
                    LIMIT $offset, $transcations_per_page";
$result_transcations = mysqli_query($conn, $sql_transcations);

// echo "$sql_transcations";
?>

<style>
    /* Target input[type="date"] and its calendar picker in dark mode */
        .dark-theme input[type="date"]::-webkit-calendar-picker-indicator {
            filter: invert(1); /* This inverts the icon color */
        }
        
        /* Ensure other styling for the form-control stays */
        .dark-theme .form-control {
            color: #dde3ea;
            background-color: var(--dark-theme);
            border-color: rgba(222, 228, 236, 0.07) !important;
        }
        
        
        select.form-control {
        width: 100% !important;
    }

    @media (max-width: 768px) {
        .col-md-4.mt-2 select.form-control {
            width: 100% !important;
            min-width: 100%;
        }
    }

    .card-header i{
        display:block !important;
    }
</style>

<div class="container" >
  <div class="row">
    <div class="col-lg-12">
      <div class="card ">
        <div class="card-body">
        <div class="row align-items-end">
    <div class="col-md-8 mt-2">
        <h5>Daily Reports<br>
            <span style="font-size: 12px;">
                <?php 
    echo ($filter_date === '') 
        ? 'All Dates' 
        : date('m/d/Y', strtotime($filter_date)); 
?>

            </span>
        </h5>
    </div>

<form method="GET" id="filtersForm" class="mb-3">
  <div class="row g-2 align-items-end">
    
    <div class="col-md-3">
      <label class="form-label fw-bold">Date</label>
      <select class="form-control" name="filter_date">
        <option value="today" <?= (!isset($_GET['filter_date']) || $_GET['filter_date'] === 'today') ? 'selected' : ''; ?>>Today</option>
        <option value="all" <?= (isset($_GET['filter_date']) && $_GET['filter_date'] === 'all') ? 'selected' : ''; ?>>All Dates</option>
        <?php foreach ($available_dates as $date): ?>
          <option value="<?= $date ?>" <?= ($filter_date == $date) ? 'selected' : ''; ?>>
            <?= date('m/d/Y', strtotime($date)); ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label fw-bold">Transaction ID</label>
      <input type="text" class="form-control" name="search_transaction" 
             value="<?= $_GET['search_transaction'] ?? ''; ?>" 
             placeholder="Enter Transaction ID">
    </div>
    <div class="col-md-1">
      <button type="submit" class="btn btn-primary w-100">Apply</button>
    </div>
    <div class="col-md-1 ">
      <button type="button" class="btn btn-secondary" id="excel_file"> Export to Excel</button>
    </div>

  </div>
</form>

    <!--<div class="col-md-2 mt-2 mb-2">-->
        <!-- Export button -->
    <!--  <button class="btn btn-secondary active btn-wave waves-effect waves-light" id="excel_file">Export to Excel</button>   -->
    <!--</div>-->
     <div class="col-md-12 mt-4">
            <ul class="pagination">
                    <?php
                        $query_string = '';
                        if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                        if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                        if (!empty($search_transaction)) $query_string .= '&search_transaction=' . urlencode($search_transaction);
                        if (!empty($filter_date)) $query_string .= '&filter_date=' . urlencode($filter_date);

                        // Previous Button
                        if ($current_page > 1) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                    </a></li>';
                        }
                    
                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                $class = ($current_page == $i) ? 'active' : '';
                                echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                            } elseif ($i == 2 || $i == $total_pages - 1) {
                                echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                            }
                        }
                    
                        // Next Button
                        if ($current_page < $total_pages) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                        }
                    ?>
                    </ul>
        </div>
</div>
                    <div class="table-responsive" bis_skin_checked="1">
                    <table id="file-datatable" class="border-top-0 table table-bordered text-nowrap key-buttons border-bottom dataTable no-footer" role="grid" aria-describedby="file-datatable_info">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Transaction id</th>
                                <th>Card</th>
                                <th>Payment Amount</th>
                                <th>Fee</th>
                                <th>Total Payment</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                
                                $counter = $offset+1;
                                if (mysqli_num_rows($result_transcations) > 0) {
                                  // output data of each row
                                  while($row_transcations = mysqli_fetch_assoc($result_transcations)) {
                                    $row_id = $row_transcations['id'];
                                    $transaction_id  = $row_transcations['transaction_id'];
                                    $amount  = (float)$row_transcations['amount'];
                                    $card  = $row_transcations['card'];
                                    $date  = $row_transcations['date'];
                                    $fee_amount  = $row_transcations['fee_amount'];
                                    $amount_without_fee  = $row_transcations['amount_without_fee'];
                                    $time  = $row_transcations['time'];
                                    
                                    // Combine date and time to form a complete datetime string
                                    $dateTimeString = $date . ' ' . $time;
                                    
                                    // Convert the combined string to a timestamp
                                    $timestamp = strtotime($dateTimeString);
                                    
                                    // Format date in US format (mm/dd/yyyy)
                                    $formatted_date = date('m/d/Y', $timestamp);
                                    
                                    // Format time in 12-hour format (hh:mm:ss AM/PM)
                                    $formatted_time = date('h:i A', $timestamp);
                                    
                            ?>
                                <tr>
                                <td><?php echo $counter; ?></td>
                                <td><?php echo $customer_name; ?></td>
                                <td><?php echo $formatted_date; ?></td>
                                <td><?php echo $formatted_time; ?></td>
                                <td><?php echo $transaction_id; ?></td>
                                <td><?php echo $card; ?></td>
                                <td>$<?php echo $amount_without_fee; ?></td>
                                <td>$<?php echo $fee_amount; ?></td>
                                <td>$<?php echo $amount ? number_format($amount, 2) : '0.00'; ?></td>
                                <td><?php echo $row_transcations['status']; ?></td>
                                <td>
                                    <a target="_blank" href="download_invoice.php?id=<?php echo $row_id ; ?>&transcation_id=<?php echo $transaction_id; ?>" title="Print">
                                          <i class="fas fa-print" style="color:red;"></i>
                                    </a>
                                </td>
                                </tr>
                                <?php 
                                    $counter++;
                                  }
                                }
                                
                                else {
                                echo '<tr><td colspan="10" class="text-center text-danger">';
                                if ($filter_date === date('Y-m-d')) {
                                    echo 'No transactions found for today.';
                                } elseif ($filter_date !== '') {
                                    echo 'No transactions found for ' . date('m/d/Y', strtotime($filter_date)) . '.';
                                } else {
                                    echo 'No transactions found.';
                                }
                                echo '</td></tr>';
                            }
                                ?>
                        </tbody>
                    </table>
                    <!-- Pagination -->
                    <ul class="pagination">
                    <?php
                        $query_string = '';
                        if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                        if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                        if (!empty($search_transaction)) $query_string .= '&search_transaction=' . urlencode($search_transaction);
                        if (!empty($filter_date)) $query_string .= '&filter_date=' . urlencode($filter_date);

                        // Previous Button
                        if ($current_page > 1) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                    </a></li>';
                        }
                    
                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                $class = ($current_page == $i) ? 'active' : '';
                                echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                            } elseif ($i == 2 || $i == $total_pages - 1) {
                                echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                            }
                        }
                    
                        // Next Button
                        if ($current_page < $total_pages) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                        }
                    ?>
                    </ul>

                </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php 
include "footer_above_section.php"; 
include "footer.php"; 
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
<script>
document.getElementById('excel_file').addEventListener('click', function () {
    let table = document.getElementById('file-datatable');
    let excelData = [];

    for (let row of table.rows) {
        let rowData = [];
        for (let cell of row.cells) {
            rowData.push(cell.innerText.trim());
        }
        excelData.push(rowData);
    }

    let wb = XLSX.utils.book_new();
    let ws = XLSX.utils.aoa_to_sheet(excelData);
    XLSX.utils.book_append_sheet(wb, ws, "Accounts");

    let wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

    function s2ab(s) {
        let buf = new ArrayBuffer(s.length);
        let view = new Uint8Array(buf);
        for (let i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
        return buf;
    }

    let link = document.createElement('a');
    link.href = URL.createObjectURL(new Blob([s2ab(wbout)], { type: 'application/octet-stream' }));
    link.download = 'accounts_data.xlsx';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
});
</script>
