<?php
include 'header.php';

$id = (int)$_GET['id'];

 $query = "
    SELECT 
        auto_payments.*, 
        transcations.id AS txn_id,
        transcations.transaction_id,
        transcations.reference_number,
        transcations.amount AS txn_amount,
        transcations.status,
        transcations.date,
        transcations.time
    FROM 
        auto_payments
    LEFT JOIN 
        transcations
    ON 
        transcations.reference_number = CONCAT('INV-', auto_payments.id)
        AND transcations.payment_type = 'recurring'
    WHERE 
        auto_payments.id = $id
";


$result = mysqli_query($conn, $query);
if (!$result) {
    die("Query Failed: " . mysqli_error($conn));
}

// fetch all transactions
$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    $data[] = $row;
}

if (empty($data)) {
    echo "<div class='alert alert-warning'>No auto payment or transaction found.</div>";
    include 'footer.php';
    exit;
}

// get auto_payments details from first row
$auto = $data[0];
$user_id = (int)$auto['user_id'];
$phone = 'N/A';

$phone_query = mysqli_query($conn, "SELECT phone FROM customers WHERE id = $user_id LIMIT 1");
if ($phone_query && mysqli_num_rows($phone_query) > 0) {
    $phone_row = mysqli_fetch_assoc($phone_query);
    $phone = $phone_row['phone'];
}

?>
<?php
$last_txn_amount = null;
$last_txn_status = null;
$last_txn_date = null; 

foreach ($data as $txn) {
    if (!empty($txn['txn_id'])) {
        $last_txn_amount = number_format(str_replace('USD', '', $txn['txn_amount']), 2);
        $last_txn_status = $txn['status'];
        $last_txn_date = date('m/d/Y', strtotime($txn['date']));
        break;
    }
}
?>
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body">
                <h4 class="main-content-label mb-3">Auto Payment Details</h4>
                <table class="table table-bordered">
                    <tr><th>Name</th><td><?= htmlspecialchars($auto['first_name'] . ' ' . $auto['last_name']) ?></td></tr>
                    <tr><th>Email</th><td><?= htmlspecialchars($auto['email']) ?></td></tr>
                    <tr><th>Phone</th><td><?= htmlspecialchars($phone) ?></td></tr>
                    <tr><th>Start Date</th><td><?= date('m/d/Y', strtotime($auto['start_date'])) ?></td></tr>
                    <tr><th>Amount ($)</th><td>$<?= htmlspecialchars($auto['amount'] > 0 ? number_format($auto['amount'], 2) : "0.00"); ?></td></tr>
                    <tr><th>Interval</th><td><?= htmlspecialchars($auto['interval_frequency']) ?></td></tr>
                    <tr><th>Payment Method</th><td><?= htmlspecialchars($auto['type']) ?></td></tr>
                    <!--<tr><th>User ID</th><td><?= htmlspecialchars($auto['user_id']) ?></td></tr>-->
                     <tr>
                        <th>Last Payment</th>
                         <td>
                        <?php 
                        if ($last_txn_amount !== null) {
                
                            $status = $last_txn_status;
                            if ($status === 'SUCCESS' || $status === 'Approved') {
                                echo "<span style='margin-bottom:8px;' class='badge bg-success'>{$last_txn_status}</span>";
                            } else {
                                echo "<span style='margin-bottom:5px;' class='badge bg-danger'>{$last_txn_status}</span>";
                            }
                            echo "<br>";
                            echo '<span>$' . $last_txn_amount . '</span> ';
                            echo "<br>";
                            echo ' <small>' . $last_txn_date . '</small>';
                        } else {
                            echo 'N/A';
                        }
                        ?>
                    </td>
                    </tr>
                </table>

                <hr>

                <h4 class="main-content-label mb-3">Recurring Transactions</h4>

                <?php
                $hasTxn = false;
                foreach ($data as $txn) {
                    if (!empty($txn['txn_id'])) {
                        $hasTxn = true;
                        break;
                    }
                }
                ?>

                <?php if ($hasTxn): ?>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Transaction ID</th>
                                <th>Reference #</th>
                                <th>Amount ($)</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Print</th>
                            </tr>
                        </thead>
                        <tbody>
                              <?php 
                                    $counter = 1;
                                    foreach ($data as $txn): 
                                        if (!empty($txn['txn_id'])): 
                                    ?>
                                        <tr>
                                        <td><?= $counter; ?></td>
                                        <td><?= $txn['transaction_id'] ?></td>
                                        <td><?= $txn['reference_number'] ?></td>
                                        <td>$<?= $txn['txn_amount'] ?></td>
                                        <td>
                                            <?php
                                            $status = $txn['status'];
                                            if ($status === 'SUCCESS' || $status === 'Approved') {
                                                echo "<span class='badge bg-success'>{$txn['status']}</span>";
                                            } else {
                                                echo "<span class='badge bg-danger'>{$txn['status']}</span>";
                                            }
                                            ?>
                                        </td>                                        
                                        <td><?= date('m/d/Y', strtotime($txn['date'])) ?></td>
                                        <td><?= $txn['time'] ?></td>
                                        <td><a target="_blank" href="download_invoice.php?id=<?php echo $txn['txn_id'] ; ?>&transcation_id=<?php echo $txn['transaction_id']; ?>" title="Print">
                                            <i class="fas fa-print" style="color:red;"></i></a>
                                        </td>
                                       </tr>
                              <?php 
                                $counter++; 
                            endif; 
                        endforeach; 
?>
                        </tbody>
                    </table>
                </div>

                <?php else: ?>
                    <div class="alert alert-info">No recurring transactions found for this auto payment.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
