<?php
include "header.php";
include "company_info.php";

// if(isset($_GET['reset_Tyler_status'])){
//     $start_date = isset($_GET['from_date']) ? mysqli_real_escape_string($conn, $_GET['from_date']) : '';
//     $end_date = isset($_GET['to_date']) ? mysqli_real_escape_string($conn, $_GET['to_date']) : '';
//   if (!empty($start_date) && !empty($end_date)) {

//       $update_transcations =  "UPDATE `transcations` SET `tyler_export`='0' WHERE `date` BETWEEN '$start_date' AND '$end_date' ";
//       mysqli_query($conn, $update_transcations);

//     }
// }

$transcations_per_page = 2000;
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $transcations_per_page;

// Get form input values
$start_date = isset($_GET['from_date']) ? mysqli_real_escape_string($conn, $_GET['from_date']) : '';
$end_date = isset($_GET['to_date']) ? mysqli_real_escape_string($conn, $_GET['to_date']) : '';
$search_name = isset($_GET['search_name']) ? mysqli_real_escape_string($conn, $_GET['search_name']) : '';

$search_account = isset($_GET['search_account']) ? mysqli_real_escape_string($conn, $_GET['search_account']) : '';

$filter_payment_type = isset($_GET['filter_payment_type']) ? mysqli_real_escape_string($conn, $_GET['filter_payment_type']) : '';
$filter_status = isset($_GET['filter_status']) ? mysqli_real_escape_string($conn, $_GET['filter_status']) : '';
$filter_method = isset($_GET['filter_method']) ? mysqli_real_escape_string($conn, $_GET['filter_method']) : '';
$filter_trx_type = isset($_GET['filter_trx_type']) ? mysqli_real_escape_string($conn, $_GET['filter_trx_type']) : '';

// sorting 
$sort_date = isset($_GET['sort_date']) ? mysqli_real_escape_string($conn, $_GET['sort_date']) : '';
$sort_amount = isset($_GET['sort_amount']) ? mysqli_real_escape_string($conn, $_GET['sort_amount']) : '';
$sort_fee = isset($_GET['sort_fee']) ? mysqli_real_escape_string($conn, $_GET['sort_fee']) : '';
$sort_total = isset($_GET['sort_total']) ? mysqli_real_escape_string($conn, $_GET['sort_total']) : '';

$active_sort = '';
$sort_order = 'DESC';
if (!empty($sort_date)) {
    $active_sort = 'date';
    $sort_order = $sort_date;
} elseif (!empty($sort_amount)) {
    $active_sort = 'amount';
    $sort_order = $sort_amount;
} elseif (!empty($sort_fee)) {
    $active_sort = 'fee';
    $sort_order = $sort_fee;
} elseif (!empty($sort_total)) {
    $active_sort = 'total';
    $sort_order = $sort_total;
} else {
    $active_sort = 'date';
    $sort_order = 'DESC';
}


$filter_sql = "1";
if (isset($_GET['search_filter'])) {
    if (!empty($start_date) && !empty($end_date)) {
        $filter_sql .= " AND `date` BETWEEN '$start_date' AND '$end_date'";
    }

    if (!empty($search_name)) {
        $filter_sql .= " AND customers.name LIKE '%$search_name%'";
    }


    if (!empty($search_account)) {
        $search_account_clean = str_replace(['-', ' '], '', $search_account);
        $filter_sql .= " AND (REPLACE(REPLACE(customer_accounts.account_number, '-', ''), ' ', '') LIKE '%$search_account_clean%' OR REPLACE(REPLACE(transcations.transaction_id, '-', ''), ' ', '') LIKE '%$search_account_clean%' )";
    }

    // echo $filter_sql;

    if (!empty($filter_payment_type)) {
        $filter_sql .= " AND transcations.type = '$filter_payment_type'";
    }

    if (!empty($filter_status)) {
        if ($filter_status == 'approved') {
            $filter_sql .= " AND (transcations.status = 'SUCCESS' OR transcations.status = 'Approved')";
        } elseif ($filter_status == 'pending') {
            $filter_sql .= " AND transcations.status = 'pending'";
        } elseif ($filter_status == 'declined') {
            $filter_sql .= " AND transcations.status NOT IN ('SUCCESS', 'Approved', 'pending')";
        } elseif ($filter_status == 'partial_refund') {
            $filter_sql .= "  AND (transcations.status = 'Partial Refund')";
        } elseif ($filter_status == 'refunded') {
            $filter_sql .= "  AND (transcations.status = 'Refunded')";
        }
    }

    if (!empty($filter_method)) {
        $filter_sql .= " AND transcations.inperson_online_check = '$filter_method'";
    }
    if (!empty($filter_trx_type)) {
        $filter_sql .= " AND transcations.payment_type = '$filter_trx_type'";
    }
}

if (empty($start_date) && empty($end_date)) {
    $start_date = date('Y-m-d', strtotime('-7 days'));
    $end_date = date('Y-m-d'); // today's date
    $filter_sql = "  `date` BETWEEN '$start_date' AND '$end_date'";
}

// Count total records
$count_query = "SELECT COUNT(*) AS total FROM `transcations` 
LEFT JOIN customers ON customers.id = transcations.user_id 
LEFT JOIN customer_accounts ON customer_accounts.customer_id = customers.id
WHERE $filter_sql";

$total_records_result = mysqli_query($conn, $count_query);
$total_records_row = mysqli_fetch_assoc($total_records_result);
$total_records = $total_records_row['total'];
$total_pages = ceil($total_records / $transcations_per_page);


if ($active_sort == 'amount') {
    $order_by = "transcations.amount_without_fee $sort_order";
} elseif ($active_sort == 'fee') {
    $order_by = "transcations.fee_amount $sort_order";
} elseif ($active_sort == 'total') {
    $order_by = "transcations.amount $sort_order";
} else {
    $order_by = "transcations.date $sort_order, transcations.time $sort_order";
}

// Fetch paginated transactions
$sql_transcations = "SELECT 
    transcations.*, 
    customers.name AS customer_name, 
    customers.phone AS phone,
    customer_accounts.account_number as account_number
    FROM `transcations` 
    LEFT JOIN customers ON customers.id = transcations.user_id 
    LEFT JOIN customer_accounts ON customer_accounts.customer_id = customers.id
    WHERE $filter_sql 
    ORDER BY $order_by
    LIMIT $offset, $transcations_per_page";
$result_transcations = mysqli_query($conn, $sql_transcations);
?>

<style>
    /* Target input[type="date"] and its calendar picker in dark mode */
    .dark-theme input[type="date"]::-webkit-calendar-picker-indicator {
        filter: invert(1);
        /* This inverts the icon color */
    }

    /* Ensure other styling for the form-control stays */
    .dark-theme .form-control {
        color: #dde3ea;
        background-color: var(--dark-theme);
        border-color: rgba(222, 228, 236, 0.07) !important;
    }

    .sort-header {
        cursor: pointer;
        user-select: none;
        position: relative;
        padding-right: 20px !important;
    }

    .sort-header:hover {
        background-color: rgba(0, 123, 255, 0.1);
    }
</style>

<script src="https://cdn.sheetjs.com/xlsx-latest/package/dist/xlsx.full.min.js"></script>

<div class="container" style="margin-top: 5rem !important;">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <form method="GET">
                        <div class="row" style="align-items: end;">
                            <div class="col-md-4 mt-2">
                                <h3 class="card-title">Transaction History</h3>
                            </div>
                            <div class="col-md-8 mt-2" style="text-align:right;">
                                <button type="button" class="btn btn-primary" onclick="confirmAndExportTyler()">Export Tyler Excel</button>
                                <!--<button class="btn btn-primary" type="submit" name="reset_Tyler_status"  onclick="return confirm('Are you sure you want to reset Tyler\'s status?');"> Reset Tyler Status</button>-->
                                <button type="button" class="btn btn-secondary active btn-wave waves-effect waves-light" onclick="exportTableToExcel()">Export Excel</button>
                            </div>
                            <div class="col-md-12 mt-4"></div>
                            <div class="col-md-2 mt-2">
                                <b>From:</b><br>
                                <input class="form-control" name="from_date" value="<?php echo htmlspecialchars($start_date); ?>" type="date" required>
                            </div>
                            <div class="col-md-2 mt-2">
                                <b>To:</b><br>
                                <input class="form-control" name="to_date" value="<?php echo htmlspecialchars($end_date); ?>" type="date" required>
                            </div>
                            <div class="col-md-2 mt-2">
                                <b>Customer name:</b><br>
                                <input class="form-control" name="search_name" value="<?php echo htmlspecialchars($search_name); ?>" type="text" placeholder="Search name">
                            </div>
                            <div class="col-md-2 mt-2">
                                <b>Account/ Transaction ID:</b><br>
                                <input class="form-control" name="search_account" value="<?php echo htmlspecialchars($_GET['search_account'] ?? ''); ?>" type="text" placeholder="Search account number/ transaction id">
                            </div>
                            <div class="col-md-1 mt-2">
                                <b>Method:</b><br>
                                <?php $selected_payment = $_GET['filter_payment_type'] ?? ''; ?>
                                <select class="form-control" name="filter_payment_type">
                                    <option value="">All</option>
                                    <option value="nmi" <?php echo ($selected_payment == 'nmi') ? 'selected' : ''; ?>>Card</option>
                                    <option value="green" <?php echo ($selected_payment == 'green') ? 'selected' : ''; ?>>eCheck</option>
                                    <option value="cash" <?php echo ($selected_payment == 'cash') ? 'selected' : ''; ?>>Cash</option>
                                </select>
                            </div>

                            <div class="col-md-1 mt-2">
                                <b>Status:</b><br>
                                <?php $selected_status = $_GET['filter_status'] ?? ''; ?>
                                <select class="form-control" name="filter_status">
                                    <option value="">All</option>
                                    <option value="approved" <?= $selected_status == 'approved' ? 'selected' : '' ?>>Approved</option>
                                    <option value="pending" <?= $selected_status == 'pending' ? 'selected' : '' ?>>Pending</option>
                                    <option value="declined" <?= $selected_status == 'declined' ? 'selected' : '' ?>>Declined</option>
                                    <option value="partial_refund" <?= $selected_status == 'partial_refund' ? 'selected' : '' ?>>Partial Refund</option>
                                    <option value="refunded" <?= $selected_status == 'refunded' ? 'selected' : '' ?>>Full Refund</option>
                                </select>

                            </div>

                            <div class="col-md-1 mt-2">
                                <b>Payment Type:</b><br>
                                <?php $selected_method = $_GET['filter_method'] ?? ''; ?>
                                <select class="form-control" name="filter_method">
                                    <option value="">All</option>
                                    <option value="In-person" <?php echo ($selected_method == 'In-person') ? 'selected' : ''; ?>>In-Person</option>
                                    <option value="Online" <?php echo ($selected_method == 'Online') ? 'selected' : ''; ?>>Online</option>
                                </select>
                            </div>

                            <div class="col-md-1 mt-2">
                                <b>Type:</b><br>
                                <?php $selected_trx_type = $_GET['filter_trx_type'] ?? ''; ?>
                                <select class="form-control" name="filter_trx_type">
                                    <option value="">All</option>
                                    <option value="recurring" <?= $selected_trx_type == 'recurring' ? 'selected' : '' ?>>Recurring</option>
                                    <option value="single_payment" <?= $selected_trx_type == 'single_payment' ? 'selected' : '' ?>>Single Payment</option>
                                </select>
                            </div>



                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-2 mt-4">
                                        <!-- Pagination -->
                                        <ul class="pagination">
                                            <?php
                                            $query_string = '';
                                            if (!empty($start_date)) $query_string .= '&search_filter=&from_date=' . urlencode($start_date);
                                            if (!empty($end_date)) $query_string .= '&search_filter=&to_date=' . urlencode($end_date);
                                            if (!empty($search_name)) $query_string .= '&search_filter=&search_name=' . urlencode($search_name);

                                            if (!empty($filter_payment_type)) $query_string .= '&search_filter=&filter_payment_type=' . urlencode($filter_payment_type);
                                            if (!empty($filter_status)) $query_string .= '&search_filter=&filter_status=' . urlencode($filter_status);
                                            if (!empty($filter_method)) $query_string .= '&search_filter=&filter_method=' . urlencode($filter_method);
                                            if (!empty($filter_trx_type)) $query_string .= '&search_filter=&filter_trx_type=' . urlencode($filter_trx_type);
                                            if (!empty($_GET['sort_date'])) $query_string .= '&sort_date=' . urlencode($_GET['sort_date']);
                                            if (!empty($_GET['sort_amount'])) $query_string .= '&sort_amount=' . urlencode($_GET['sort_amount']);
                                            if (!empty($_GET['sort_fee'])) $query_string .= '&sort_fee=' . urlencode($_GET['sort_fee']);
                                            if (!empty($_GET['sort_total'])) $query_string .= '&sort_total=' . urlencode($_GET['sort_total']);
                                            if ($current_page > 1) {
                                                echo '<li class="paginate_button page-item"><a href="?search_filter=&page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i></a></li>';
                                            }

                                            for ($i = 1; $i <= $total_pages; $i++) {
                                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                                    $class = ($current_page == $i) ? 'active' : '';
                                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?search_filter=&page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                                    echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                                                }
                                            }

                                            if ($current_page < $total_pages) {
                                                echo '<li class="paginate_button page-item"><a href="?search_filter=&page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                                            }
                                            ?>
                                        </ul>
                                    </div>
                                    <div class="col-md-2 mt-4" style="text-align:right; margin-left:auto;">
                                        <button class="btn btn-primary" type="submit" name="search_filter">Apply</button>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive mt-4">
                        <table id="file-datatable" class="table table-bordered text-nowrap key-buttons">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Customer Name</th>
                                    <th class="sort-header" onclick="sortColumn('date', '<?php echo ($active_sort == 'date' && $sort_order == 'DESC') ? 'ASC' : 'DESC'; ?>')">
                                        Date / Time
                                        <?php if ($active_sort == 'date'): ?>
                                            <?php echo ($sort_order == 'DESC' ? '↓' : '↑'); ?>
                                        <?php else: ?>
                                            ↕
                                        <?php endif; ?>
                                    </th>
                                    <th>DETAILS</th>
                                    <th class="sort-header" onclick="sortColumn('amount', '<?php echo ($active_sort == 'amount' && $sort_order == 'DESC') ? 'ASC' : 'DESC'; ?>')">
                                        Amount
                                        <?php if ($active_sort == 'amount'): ?>
                                            <?php echo ($sort_order == 'DESC' ? '↓' : '↑'); ?>
                                        <?php else: ?>
                                            ↕
                                        <?php endif; ?>
                                    </th>
                                    <th class="sort-header" onclick="sortColumn('fee', '<?php echo ($active_sort == 'fee' && $sort_order == 'DESC') ? 'ASC' : 'DESC'; ?>')">
                                        Fee
                                        <?php if ($active_sort == 'fee'): ?>
                                            <?php echo ($sort_order == 'DESC' ? '↓' : '↑'); ?>
                                        <?php else: ?>
                                            ↕
                                        <?php endif; ?>
                                    </th>
                                    <th class="sort-header" onclick="sortColumn('total', '<?php echo ($active_sort == 'total' && $sort_order == 'DESC') ? 'ASC' : 'DESC'; ?>')">
                                        Total
                                        <?php if ($active_sort == 'total'): ?>
                                            <?php echo ($sort_order == 'DESC' ? '↓' : '↑'); ?>
                                        <?php else: ?>
                                            ↕
                                        <?php endif; ?>
                                    </th>
                                    <th>Method</th>
                                    <th style='max-width: 100px; white-space: normal;'>Status</th>
                                    <th>Type</th>
                                    <th>Tyler </th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $counter = $offset + 1;

                                $A_total_amount = $A_total_fee = $A_toal_with_fee =  0;
                                if (mysqli_num_rows($result_transcations) > 0) {
                                    while ($row = mysqli_fetch_assoc($result_transcations)) {
                                        $transaction_id  = $row['transaction_id'];
                                        $amount = $row['amount'];
                                        $customer_phone = $row['phone'];
                                        $customer_accounts = $row['account_number'];
                                        if (!empty($customer_accounts)) {
                                            $customer_accounts = "<br>Acc. # $customer_accounts ";
                                        }
                                        if (!empty($customer_phone)) {
                                            $customer_phone = preg_replace("/(\d{3})(\d{3})(\d{4})/", "($1) $2-$3", $customer_phone);
                                            $customer_phone = "<br>Phone: <i style='color:gray'>$customer_phone</i>";
                                        }
                                        $amount = str_replace('USD', '', $amount);
                                        $amount = number_format((float)$amount, 2);
                                        $transaction_date = $row['date'];
                                        $transaction_time = $row['time'];
                                        $payment_type = $row['type'];
                                        $payment_type_des = '';
                                        if ($payment_type == 'nmi') {
                                            $payment_type_des = 'Card';
                                        } elseif ($payment_type == 'green') {
                                            $payment_type_des = 'eCheck';
                                        } elseif ($payment_type == 'cash') {
                                            $payment_type_des = 'Cash';
                                        }

                                        $payment_status = $row['status'];
                                        $tyler_exp = "";
                                        if ($payment_status == 'Approved' || $payment_status == 'SUCCESS') {
                                            $tyler_exp = "<span style='color: green;'>&#10004;</span>";
                                        }
                                        // Combine the date and time into one string
                                        $transactionDateTime = $transaction_date . ' ' . $transaction_time;

                                        // Convert to a timestamp
                                        $timestamp = strtotime($transactionDateTime);

                                        // Format the combined date and time in US format (mm/dd/yyyy hh:mm:ss AM/PM)
                                        $formatted_transaction = date('m/d/Y h:i A', $timestamp);

                                        $A_total_amount = $A_total_amount + $row['amount_without_fee'];
                                        $A_total_fee = $A_total_fee + $row['fee_amount'];
                                        $A_toal_with_fee = $A_toal_with_fee + $amount;
                                        echo "<tr>";
                                        echo "<td>{$counter}</td>";
                                        echo "<td>{$row['customer_name']}$customer_accounts$customer_phone</td>";
                                        echo "<td>$formatted_transaction</td>";
                                        echo "<td>{$row['transaction_id']} <br> {$row['card']}</td>";
                                        echo "<td>" . '$' . "{$row['amount_without_fee']}</td>";
                                        echo "<td>" . '$' . "{$row['fee_amount']}</td>";
                                        echo "<td>" . '$' . "$amount</td>";
                                        echo "<td>{$payment_type_des}</td>";
                                        echo "<td style='max-width: 100px; white-space: normal;'>{$row['status']} </td>";
                                        echo "<td>{$row['payment_type']}<br> <i><b> {$row['inperson_online_check']} </b></i></td>";

                                        echo "<td>";
                                        if ($row['tyler_export'] == 1) {
                                            // echo "<span style='color: green;'>&#10004;</span>"; // 
                                        } else {
                                            echo ""; // You can also use a red cross or leave it empty
                                        }
                                        echo "$tyler_exp";
                                        echo "</td>";
                                        echo '<td><a target="_blank" href="download_invoice.php?id=' . $row['id']  . '&transcation_id=' . $transaction_id . '" title="Print"><i class="fas fa-print" style="color:red;"></i></a>
                            <b>&nbsp;&nbsp;&nbsp;<a style="color:green !important; font-size:1rem !important;" href="view_transaction_details.php?id=' . $row['id'] . '" title="View details"><i class="bi bi-eye-fill"></i></a></b></td>';
                                        echo "</tr>";
                                        $counter++;
                                    }

                                    $A_total_amount = number_format($A_total_amount, 2);
                                    $A_total_fee = number_format($A_total_fee, 2);
                                    $A_toal_with_fee = number_format($A_toal_with_fee, 2);
                                    echo "<tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><b>Total</b></td>
                                <td><b>$$A_total_amount</b></td>
                                <td><b>$$A_total_fee</b></td>
                                <td><b>$$A_toal_with_fee</b></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                
                        </tr>";
                                } else {
                                    echo "<tr><td colspan='7' class='text-center'>No transactions found for the selected filters.</td></tr>";
                                }
                                ?>
                            </tbody>
                        </table>

                        <!-- Pagination -->
                        <ul class="pagination">
                            <?php
                            $query_string = '';
                            if (!empty($start_date)) $query_string .= '&search_filter=&from_date=' . urlencode($start_date);
                            if (!empty($end_date)) $query_string .= '&search_filter=&to_date=' . urlencode($end_date);
                            if (!empty($search_name)) $query_string .= '&search_filter=&search_name=' . urlencode($search_name);

                            if (!empty($filter_payment_type)) $query_string .= '&search_filter=&filter_payment_type=' . urlencode($filter_payment_type);
                            if (!empty($filter_status)) $query_string .= '&search_filter=&filter_status=' . urlencode($filter_status);
                            if (!empty($filter_method)) $query_string .= '&search_filter=&filter_method=' . urlencode($filter_method);
                            if (!empty($filter_trx_type)) $query_string .= '&search_filter=&filter_trx_type=' . urlencode($filter_trx_type);
                            if (!empty($_GET['sort_date'])) $query_string .= '&sort_date=' . urlencode($_GET['sort_date']);
                            if (!empty($_GET['sort_amount'])) $query_string .= '&sort_amount=' . urlencode($_GET['sort_amount']);
                            if (!empty($_GET['sort_fee'])) $query_string .= '&sort_fee=' . urlencode($_GET['sort_fee']);
                            if (!empty($_GET['sort_total'])) $query_string .= '&sort_total=' . urlencode($_GET['sort_total']);
                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a href="?search_filter=&page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
</a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?search_filter=&page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a href="?search_filter=&page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>

<script>
function confirmAndExportTyler() {
    const code = prompt("Are you sure you want to reset Tyler's status?\n\nEnter the secret code to proceed:");

    if (code === "100001") {
        // Allow download
        window.location.href = "export_tyler_data.php?confirm_uha=YES";
    } else if (code !== null) {
        alert("Invalid code. Export canceled.");
    }
    // if code is null, user pressed Cancel, do nothing
}
</script>

<!-- JS Export to Excel -->
<script>
    function exportTableToExcel() {
        var table = document.getElementById("file-datatable");
        var wb = XLSX.utils.table_to_book(table, {
            sheet: "Transactions"
        });
        XLSX.writeFile(wb, "transaction_history.xlsx");
    }

    function sortColumn(column, order) {
        const url = new URLSearchParams(window.location.search);

        // Remove all sort parameters
        url.delete('sort_date');
        url.delete('sort_amount');
        url.delete('sort_fee');
        url.delete('sort_total');

        // Set the active sort
        url.set('sort_' + column, order);

        if (!url.has('search_filter')) {
            url.set('search_filter', '');
        }

        window.location.href = '?' + url.toString();
    }
</script>