<?php
include('connection.php'); 
include('functions.php');
header('Content-Type: application/json');

if (isset($_GET['term'])) {
    $term = trim($_GET['term']);

    $sql = "SELECT c.id, c.name, c.email, ca.account_number, c.address, c.phone
            FROM customers c
            JOIN customer_accounts ca ON c.id = ca.customer_id
            WHERE c.name LIKE CONCAT('%', ?, '%')
               OR c.email LIKE CONCAT('%', ?, '%')
               OR ca.account_number LIKE CONCAT('%', ?, '%')
               OR c.address LIKE CONCAT('%', ?, '%')
                OR c.phone LIKE CONCAT('%', ?, '%')

            LIMIT 10";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssss", $term, $term, $term, $term, $term);
    $stmt->execute();
    $result = $stmt->get_result();

    $suggestions = [];
     while ($row = $result->fetch_assoc()) {
        $suggestions[] = [
            'id'    => $row['id'],
            'name'  => $row['name'],
            'email' => $row['email'],
            'account' => $row['account_number'],
            'address' => $row['address'],
            'phone' => $row['phone']
        ];
    }

    echo json_encode($suggestions);
}
?>

