<?php 
include 'header.php';
?>

<script>
function confirmDelete() {
    return confirm("Are you sure you want to delete this customer?");
}
</script>

<?php
$alert = "";

// Delete customer logic
if (isset($_GET['customer_id'])) {
    $customer_id = (int) $_GET['customer_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "DELETE FROM `customers` WHERE id = $customer_id";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button"></button>
                        <strong>Well done!</strong> Customer deleted successfully.
                      </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button"></button>
                        <strong>Error!</strong> Failed to delete the customer.
                      </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_customer.php?customer_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

$search = "";
$where = "1"; // Default to all customers

// If search is provided, build the WHERE clause
if (isset($_GET['search']) && !empty(trim($_GET['search']))) {
    $search = mysqli_real_escape_string($conn, trim($_GET['search']));
    $where = "customers.name LIKE '%$search%' OR 
              customers.email LIKE '%$search%' OR 
              customers.phone LIKE '%$search%' OR 
              customers.address LIKE '%$search%'";
}

// Pagination setup
$customers_per_page = 1000;
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

// Get total customer count with the WHERE clause
$total_count_query = "SELECT COUNT(*) as total FROM `customers` WHERE $where";
$total_count_result = mysqli_query($conn, $total_count_query);
$total_count_row = mysqli_fetch_assoc($total_count_result);
$total_records = $total_count_row['total'];
$total_pages = ceil($total_records / $customers_per_page);

// Fetch paginated customers with the WHERE clause
$query_customers = "SELECT customers.*, accounts.account_number 
                    FROM `customers` 
                    LEFT JOIN customer_accounts AS accounts ON accounts.customer_id = customers.id
                    WHERE $where
                    ORDER BY name ASC 
                    LIMIT $offset, $customers_per_page";
$result_customers = mysqli_query($conn, $query_customers);
?>
<style>
    .card-header i{
        display:block !important;
    }
</style>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-4">
                        <h3 class="card-title">Manage Customers</h3>
                    </div>
                    <div class="col-md-4">
                        <form method="GET" class="mb-3">
                            <div class="input-group">
                                <input type="text" name="search" class="form-control" placeholder="Search by name, email, phone, address..." value="<?php echo htmlspecialchars($search); ?>">
                                <button type="submit" class="btn btn-primary">Search</button>
                            </div>
                        </form>
                    </div>
                    <div class="col-md-2">
                        <a class="btn btn-outline-primary float-end" href="add_customer.php">Add New Customer Account</a>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-secondary active btn-wave waves-effect waves-light" id="excel_file">Export to Excel</button>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                         <ul class="pagination">
                            <?php
                            // Previous page button
                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page - 1) . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                            }

                            // Pagination buttons
                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . $i . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            // Next page button
                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page + 1) . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>

                <div class="table-responsive">
                    <table id="file-datatable" class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Phone</th>
                                <th>Account Number</th>
                                <th>Address</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_array($result_customers)) {
                                $created_at = $row['created_at'];
                                // Convert to a timestamp
                                $timestamp = strtotime($created_at);
                                
                                // Format the combined date and time in US format (mm/dd/yyyy hh:mm:ss AM/PM)
                                $formatted_created_date = date('m/d/Y h:i A', $timestamp);
                                echo "<tr>
                                    <td>{$counter}</td>
                                    <td>" . htmlspecialchars($row['name']) . "</td>
                                    <td>" . htmlspecialchars($row['email']) . "</td>
                                    <td>" . htmlspecialchars($row['phone']) . "</td>
                                    <td>" . htmlspecialchars($row['account_number']) . "</td>
                                    <td>" . htmlspecialchars($row['address']) . "</td>
                                    <td>" . $formatted_created_date . "</td>
                                    <td>
                                        <a href='update_customer.php?customer_id={$row['id']}'><i class='si si-note' title='Update Customer'></i></a>
                                        <a href='manage_customer.php?customer_id={$row['id']}'><i class='si si-close' title='Delete Customer'></i></a>
                                    </td>
                                </tr>";
                                $counter++;
                            }
                            ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="mt-3">
                        <ul class="pagination">
                            <?php
                            // Previous page button
                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page - 1) . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                            }

                            // Pagination buttons
                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . $i . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            // Next page button
                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page + 1) . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Export to Excel -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
<script>
$(document).ready(function () {
    $('#excel_file').click(function () {
        let table = $('#file-datatable');
        let rows = table.find('tr');
        let excelData = [];

        rows.each(function () {
            let row = [];
            $(this).find('td, th').each(function () {
                row.push($(this).text().trim());
            });
            excelData.push(row);
        });

        let wb = XLSX.utils.book_new();
        let ws = XLSX.utils.aoa_to_sheet(excelData);
        XLSX.utils.book_append_sheet(wb, ws, "Customers");

        let wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

        function s2ab(s) {
            let buf = new ArrayBuffer(s.length);
            let view = new Uint8Array(buf);
            for (let i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
            return buf;
        }

        let link = document.createElement('a');
        link.href = URL.createObjectURL(new Blob([s2ab(wbout)], { type: 'application/octet-stream' }));
        link.download = 'customers_data.xlsx';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });
});
</script>
