<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this Account?");
    }
</script>
<style>
    .card-header i{
        display:block !important;
    }
</style>
<?php
$alert = "";
if (isset($_GET['account_id'])) {
    $customer_id = (int) $_GET['account_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `customer_accounts` SET `is_active`='0' WHERE `id`='$customer_id'";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> Customer deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the customer.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_accounts.php?account_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

// Pagination setup
$customers_per_page = 1000;
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

// Get search input
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

// Build query condition
$search_condition = "";
if (!empty($search)) {
    $search_escaped = mysqli_real_escape_string($conn, $search);
    $search_condition = " AND (customer_accounts.last_update LIKE '%$search_escaped%' OR customers.name LIKE '%$search_escaped%' OR customers.email LIKE '%$search_escaped%' OR customers.phone LIKE '%$search_escaped%' OR customer_accounts.account_number LIKE '%$search_escaped%')";
}

// Fetch paginated customer accounts with search condition
$query_customers = "SELECT customer_accounts.*, customers.name, customers.email as customer_email, customers.phone 
                    FROM customer_accounts 
                    LEFT JOIN customers ON customers.id = customer_accounts.customer_id 
                    WHERE customer_accounts.is_active = 1 $search_condition
                    ORDER BY customers.name ASC 
                    LIMIT $offset, $customers_per_page";

$result_customers = mysqli_query($conn, $query_customers);

// Get total count for pagination
$total_count_query = "SELECT COUNT(*) as total 
                      FROM customer_accounts 
                      LEFT JOIN customers ON customers.id = customer_accounts.customer_id 
                      WHERE customer_accounts.is_active = 1 $search_condition";
$total_count_result = mysqli_query($conn, $total_count_query);
$total_count_row = mysqli_fetch_assoc($total_count_result);
$total_records = $total_count_row['total'];
$total_pages = ceil($total_records / $customers_per_page);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-4">
                        <h3 class="card-title">Manage Accounts</h3>
                    </div>
                    <div class="col-md-4">
                    <form method="GET" action="manage_accounts.php" class="mb-3">
                    <div class="input-group ">
                        <input type="text" name="search" class="form-control" placeholder="Search by name, phone, email or account number" value="<?php echo htmlspecialchars($search); ?>">
                        <button type="submit" class="btn btn-primary">Search</button>
                    </div>
                </form>
                    </div>
                    <div class="col-md-2">
                        <a class="btn btn-outline-primary float-end" href="add_customer.php" title="Add New Account">Add New Customer Account</a>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-secondary active btn-wave waves-effect waves-light" id="excel_file">Export to Excel</button>
                    </div>
                </div>
                <div class="col-md-12">
                         <ul class="pagination">
                            <?php
                            $query_string = "&search=" . urlencode($search);

                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?page=' . ($current_page - 1) . $query_string . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                    </a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?page=' . $i . $query_string . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?page=' . ($current_page + 1) . $query_string . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                </div>
            </div>

            <div class="card-body" style="padding-top:0px;">
                <?php echo $alert; ?>

                <!-- Search Form -->
                

                <div class="table-responsive">
                    <table id="file-datatable" class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>E-mail</th>
                                <td>Phone</td>
                                <th>Account Number</th>
                                <th>Balance</th>
                                <th>Last Update</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            if (mysqli_num_rows($result_customers) > 0) {
                                while ($row = mysqli_fetch_array($result_customers)) {
                                    $last_update = $row['last_update'];
                                    // Check if the $last_update is not empty or invalid
                                    if (!empty($last_update) && strtotime($last_update) !== false) {
                                        // Convert the string to a timestamp
                                        $timestamp = strtotime($last_update);
                                        
                                        // Format both date and time in US format (mm/dd/yyyy hh:mm:ss AM/PM)
                                        $formatted_last_update = date('m/d/Y h:i A', $timestamp);
                                    } else {
                                        // Handle the case where the date is empty or invalid
                                        $formatted_last_update = '';
                                    }
                            ?>
                                    <tr>
                                        <td><?php echo $counter++; ?></td>
                                        <td><?php echo htmlspecialchars($row['name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['customer_email']); ?></td>
                                        <td><?php echo htmlspecialchars($row['phone']);?></td>
                                        <td><?php echo htmlspecialchars($row['account_number']); ?></td>
                                        <td>$<?php echo number_format($row['balance'] < 0 ? 0 : htmlspecialchars($row['balance']), 2); ?></td>
                                        <td><?php echo $formatted_last_update; ?></td>
                                        <td>
                                            <a href="update_account.php?account_id=<?php echo $row['id']; ?>"><i class="si si-note" title="Update Account"></i></a>
                                            <a href="manage_accounts.php?account_id=<?php echo $row['id']; ?>"><i class="si si-close" title="Delete Account"></i></a>
                                        </td>
                                    </tr>
                            <?php
                                }
                            } else {
                                echo '<tr><td colspan="7" class="text-center">No results found.</td></tr>';
                            }
                            ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="mt-3">
                        <ul class="pagination">
                            <?php
                            $query_string = "&search=" . urlencode($search);

                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?page=' . ($current_page - 1) . $query_string . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                    </a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?page=' . $i . $query_string . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?page=' . ($current_page + 1) . $query_string . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<!-- Export to Excel -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
<script>
$(document).ready(function () {
    $('#excel_file').click(function() {
        let table = $('#file-datatable'); 
        let rows = table.find('tr');
        let excelData = [];

        rows.each(function() {
            let row = [];
            $(this).find('td, th').each(function() {
                let text = $(this).text().trim();
                row.push(text);
            });
            excelData.push(row);
        });

        let wb = XLSX.utils.book_new();
        let ws = XLSX.utils.aoa_to_sheet(excelData);
        XLSX.utils.book_append_sheet(wb, ws, "Accounts");

        let wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

        function s2ab(s) {
            let buf = new ArrayBuffer(s.length);
            let view = new Uint8Array(buf);
            for (let i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
            return buf;
        }

        let link = document.createElement('a');
        link.href = URL.createObjectURL(new Blob([s2ab(wbout)], { type: 'application/octet-stream' }));
        link.download = 'accounts_data.xlsx';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });
});
</script>
