<?php 

include('connection.php');

function fee_calculation($amount){
    global $conn; // needed to use $conn inside the function

    $payment_fee = "SELECT * FROM `payment_fee`";
    $result_payment_fee = mysqli_query($conn, $payment_fee);

    if (mysqli_num_rows($result_payment_fee) > 0) {
        while($row_payment_fee = mysqli_fetch_assoc($result_payment_fee)) {
            $description = $row_payment_fee['description'];
            $fee_amount = (float) $row_payment_fee['amount']; // percentage (e.g. 2.5)
            $type = $row_payment_fee['type']; // 'percent' or 'fixed'
            $minimum_fixed_tax = (float) $row_payment_fee['min_fixed']; // minimum $2.50

            if($type === 'percent') {
                $percent_fee = ($amount * $fee_amount) / 100;
                $final_fee = max($minimum_fixed_tax, $percent_fee);
                $total = $amount + $final_fee;

                return [
                    'description' => $description,
                    'original_amount' => round($amount, 2),
                    'fee' => round($final_fee, 2),
                    'total' => round($total, 2)
                ];
            } elseif ($type === 'fixed') {
                // If needed to support flat fixed fees
                $final_fee = max($minimum_fixed_tax, $fee_amount);
                $total = $amount + $final_fee;

                return [
                    'description' => $description,
                    'original_amount' => round($amount, 2),
                    'fee' => round($final_fee, 2),
                    'total' => round($total, 2)
                    
                ];
            }
        }
    } else {
        return [
            'error' => 'No fee configuration found.'
        ];
    }
}




function fee_calculation_echeck($amount){
    global $conn; // needed to use $conn inside the function

    $payment_fee = "SELECT * FROM `payment_fee`";
    $result_payment_fee = mysqli_query($conn, $payment_fee);

    if (mysqli_num_rows($result_payment_fee) > 0) {
        while($row_payment_fee = mysqli_fetch_assoc($result_payment_fee)) {
            $description = $row_payment_fee['description'];
            $fee_amount = (float) $row_payment_fee['amount']; // percentage (e.g. 2.5)
            $type = $row_payment_fee['type']; // 'percent' or 'fixed'
            $minimum_fixed_tax = (float) $row_payment_fee['min_fixed']; // minimum $2.50

            if($type === 'percent') {
                $percent_fee = ($amount * $fee_amount) / 100;
                // $final_fee = max($minimum_fixed_tax, $percent_fee);
                $final_fee = 0.00;
                $total = $amount + $final_fee;

                return [
                    'description' => $description,
                    'original_amount' => round($amount, 2),
                    'fee' => round($final_fee, 2),
                    'total' => round($total, 2)
                ];
            } elseif ($type === 'fixed') {
                // If needed to support flat fixed fees
                // $final_fee = max($minimum_fixed_tax, $fee_amount);
                
                $final_fee = 0.00;
                $total = $amount + $final_fee;

                return [
                    'description' => $description,
                    'original_amount' => round($amount, 2),
                    'fee' => round($final_fee, 2),
                    'total' => round($total, 2)
                    
                ];
            }
        }
    } else {
        return [
            'error' => 'No fee configuration found.'
        ];
    }
}



// // Example usage:
// $result = fee_calculation(1160.00);

// if (!isset($result['error'])) {
//     $amount_without_tax = $result['original_amount'];
//     $fee = $result['fee'];
//     $amount_with_tax = $result['total'];

//     echo "Amount without tax: $" . number_format($amount_without_tax, 2) . "<br>";
//     echo "Fee: $" . number_format($fee, 2) . "<br>";
//     echo "Amount with tax: $" . number_format($amount_with_tax, 2) . "<br>";
// } else {
//     echo "Error: " . $result['error'];
// }



// Card Encryption Function
function encrypt_card($account_number, $cvv, $expiry_input) {
    $account_number = preg_replace('/\D/', '', $account_number);
    $cvv = preg_replace('/\D/', '', $cvv);
    $expiry_mmyy = str_replace('/', '', $expiry_input);
    $combined = $expiry_mmyy . $account_number . $cvv;

    $reversed = strrev($combined);

    $digitMap = [
        '0' => 'QWER', '1' => 'TYUI', '2' => 'ASDF', '3' => 'GHJK', '4' => 'ZXCV',
        '5' => 'BNMK', '6' => 'PLMO', '7' => 'IUYT', '8' => 'MNBC', '9' => 'REWQ'
    ];

    $encodedLetters = '';
    foreach (str_split($reversed) as $digit) {
        $encodedLetters .= $digitMap[$digit];
    }

    $charMap = array_combine(range('A', 'Z'), range(1001, 1026));
    $numbers = '';
    for ($i = 0; $i < strlen($encodedLetters); $i++) {
        $char = $encodedLetters[$i];
        $numbers .= $charMap[$char];
    }

    $base64_1 = base64_encode($numbers);
    $base64_2 = base64_encode($base64_1);

    $digitToWordMap = [
        '0' => 'AHPLA', '1' => 'OVARB', '2' => 'EILRAHC', '3' => 'ATLED', '4' => 'ELGAE',
        '5' => 'NTXOF', '6' => 'MFLOG', '7' => 'LETOH', '8' => 'AIDNI', '9' => 'EILUJ'
    ];

    $final_encoded = '';
    for ($i = 0; $i < strlen($base64_2); $i++) {
        $char = $base64_2[$i];
        $final_encoded .= is_numeric($char) ? $digitToWordMap[$char] : $char;
    }

    // echo "$final_encoded";
    
    // Final layer of base64
    return base64_encode($final_encoded);
}

// Card Decryption Function
function decrypt_card($encrypted) {
    // First, decode final base64 layer
    $layer1_decoded = base64_decode($encrypted);

    $wordToDigitMap = [
        'AHPLA' => '0', 'OVARB' => '1', 'EILRAHC' => '2', 'ATLED' => '3', 'ELGAE' => '4',
        'NTXOF' => '5', 'MFLOG' => '6', 'LETOH' => '7', 'AIDNI' => '8', 'EILUJ' => '9'
    ];

    $pattern = implode('|', array_keys($wordToDigitMap));
    $cleaned = preg_replace_callback('/' . $pattern . '|./', function ($matches) use ($wordToDigitMap) {
        $char = $matches[0];
        return $wordToDigitMap[$char] ?? $char;
    }, $layer1_decoded);

    $base64_once = base64_decode($cleaned);
    $number_string = base64_decode($base64_once);

    $numToCharMap = array_combine(range(1001, 1026), range('A', 'Z'));
    $letterToDigitMap = [
        'QWER' => '0', 'TYUI' => '1', 'ASDF' => '2', 'GHJK' => '3', 'ZXCV' => '4',
        'BNMK' => '5', 'PLMO' => '6', 'IUYT' => '7', 'MNBC' => '8', 'REWQ' => '9'
    ];

    $letters = '';
    for ($i = 0; $i < strlen($number_string); $i += 4) {
        $chunk = substr($number_string, $i, 4);
        $letters .= $numToCharMap[(int)$chunk] ?? '';
    }

    $digits = '';
    for ($i = 0; $i < strlen($letters); $i += 4) {
        $chunk = substr($letters, $i, 4);
        $digits .= $letterToDigitMap[$chunk] ?? '';
    }

    $original = strrev($digits);

    $expiry = substr($original, 0, 4);
    $account = substr($original, 4, 16);
    $cvv = substr($original, 20);

    return [
        'expiry' => substr($expiry, 0, 2) . '' . substr($expiry, 2, 2),
        'account_number' => $account,
        'cvv' => $cvv
    ];
}
