<?php


$processedFolder = 'processed/';
$downloadReady = false;
$downloadFile = '';

if (!is_dir($processedFolder)) {
    mkdir($processedFolder, 0777, true);
}

// Get all CSV files in the current folder (excluding processed/)
$csvFiles = glob("*.csv");

// Prepare array to hold file info
$files = [];

foreach ($csvFiles as $file) {
    if (is_file($file)) {
        $files[] = [
            'name' => $file,
            'modified' => filemtime($file)
        ];
    }
}

usort($files, function ($a, $b) {
    return $b['modified'] - $a['modified'];
});


if (!empty($files)) {
    $topFile = $files[0]['name'];
    $destination = $processedFolder . basename($topFile);

    if (rename($topFile, $destination)) {
        $downloadReady = true;
        $downloadFile = $destination;
        array_shift($files);
    } else {
        echo "<p style='color: red;'>Failed to move file: $topFile</p>";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>CSV File List</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
        padding: 20px;
        }
        table { width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
        }
        th, td { padding: 10px;
        border: 1px solid #ccc;
        text-align:center;
            
        }
        th { 
            background-color: #f5f5f5;
            }
        .download-box {
            background-color: #e6ffe6;
            border: 1px solid #4CAF50;
            padding: 15px;
            margin-top: 20px;
            border-radius: 5px;
            color: #2d662d;
        }
    </style>
</head>
<body>

    <h2>CSV Files</h2>

    <?php if ($downloadReady): ?>

        <iframe src="<?= htmlspecialchars($downloadFile) ?>" style="display: none;"></iframe>
    <?php endif; ?>

    <?php if (count($files) > 0): ?>
        <table>
            <tr>
                 <th>#</th>
                <th>Filename</th>
                <th>Last Modified</th>
            </tr>
            <?php $i = 1; ?>
            <?php foreach ($files as $file): ?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td><?= htmlspecialchars($file['name']) ?></td>
                    <td><?= date("Y-m-d H:i:s", $file['modified']) ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
    <?php else: ?>
        <p>No remaining CSV files found.</p>
    <?php endif; ?>

</body>
</html>
